<?php
namespace UiCoreElements;

/**
 * Scripts and Styles Class
 */
class Elementor
{
    public function __construct()
    {
        $this->init_utils();

        require_once UICORE_ELEMENTS_INCLUDES . '/class-widget-base.php';
        if(!class_exists('\UiCoreAnimate\Base')){
            require_once UICORE_ELEMENTS_INCLUDES . '/class-animate.php';
		}


        add_action('elementor/elements/categories_registered', [$this, 'create_custom_category'], 999);
        add_action('elementor/controls/register', [$this, 'init_controls']);
        add_action('elementor/widgets/register', [$this, 'init_widgets']);

        // WPML String Translation plugin exist check
        if ( defined( 'WPML_ST_VERSION' ) ) {

            if ( class_exists( 'WPML_Elementor_Module_With_Items' ) ) {
                $this->load_wpml_modules();
            }

            add_filter( 'wpml_elementor_widgets_to_translate', [$this, 'add_translatable_nodes'] );
        }

    }

    public function init_widgets()
    {
        //Only working with UiCore Framework
        if(defined('UICORE_ASSETS')){
            require_once UICORE_ELEMENTS_INCLUDES . '/widgets/post-grid.php';
        }

        require_once UICORE_ELEMENTS_INCLUDES . '/widgets/highlighted-text.php';
        require_once UICORE_ELEMENTS_INCLUDES . '/widgets/advanced-post-grid.php';
        require_once UICORE_ELEMENTS_INCLUDES . '/widgets/counter.php';
        require_once UICORE_ELEMENTS_INCLUDES . '/widgets/icon-box.php';
        require_once UICORE_ELEMENTS_INCLUDES . '/widgets/accordion.php';
        require_once UICORE_ELEMENTS_INCLUDES . '/widgets/icon-list.php';

        require_once UICORE_ELEMENTS_INCLUDES . '/widgets/theme-builder/the-content.php';
        require_once UICORE_ELEMENTS_INCLUDES . '/widgets/theme-builder/the-title.php';
        require_once UICORE_ELEMENTS_INCLUDES . '/widgets/theme-builder/post-meta.php';
        require_once UICORE_ELEMENTS_INCLUDES . '/widgets/theme-builder/page-description.php';
    }


    public function init_controls()
    {
    require UICORE_ELEMENTS_INCLUDES . '/controls/class-post-filter-control.php';
    }


    public function init_utils()
    {
        require_once UICORE_ELEMENTS_INCLUDES . '/utils/meta-component.php';
        require_once UICORE_ELEMENTS_INCLUDES . '/utils/pagination.php';
    }

    function create_custom_category($elements_manager)
    {
        $elements_manager->add_category('uicore', [
            'title' => __('UiCore', 'uicore'),
            'icon' => 'fa fa-plug',
        ]);
    }

    function load_wpml_modules()
    {
        require_once( UICORE_ELEMENTS_INCLUDES. '/compatibility/class-wpml-ui-highlighted-text.php');
    }

    function add_translatable_nodes( $nodes_to_translate )
    {
        $nodes_to_translate[ 'highlighted-text' ] = [
			'conditions' => [ 'widgetType' => 'highlighted-text' ],
			'fields'     => [],
			'integration-class' => '\UiCoreElements\Compatibility\WPML_UI_HighlightedText',
		];
        return $nodes_to_translate;
    }
}
