<?php

namespace UiCoreElements;

/**
 * Admin Pages Handler
 */
class Admin {

    /**
     * Constructor function to initialize hooks
     *
     * @return void
     */
    public function __construct() {
        add_action( 'elementor/editor/before_enqueue_scripts', [ $this, 'animate_elementor_wrapp' ] );
        add_action( 'elementor/editor/after_enqueue_scripts', [ $this, 'animate_elementor_wrapp' ], 1 );

        $this->elementor_style();

        // add_action( 'admin_menu', [ $this, 'admin_menu' ] );

    }

    /**
     * Add admin menu page
     *
     * @return void
     */
    public function admin_menu() {

          //Settings page ( only required if uicore framework is not active )
          if(!\class_exists('\UiCore\Helper')){
            $hook = add_submenu_page( 'options-general.php', 'UiCore Animate', 'UiCore Animate', 'manage_options', 'uicore-animate', [ $this, 'plugin_page' ] );
            // Add initialization hooks only when the plugin page is loaded
            add_action( 'load-' . $hook, [ $this, 'init_hooks' ] );
          }

        //Connect handle
        add_submenu_page(null, 'UiCore Connect', 'UiCore Connect', 'manage_options', 'uicore_connect_elements', [$this, 'connect_page_callback']);
    }

    /**
     * Render plugin page
     *
     * @return void
     */
    public function plugin_page() {
        echo '<div id="uianim-settings"></div>';
    }

    /**
     * Elementor Editor Style, Fonts and Scripts
     *
     * @return void
     * @author Andrei Voica <andrei@uicore.co
     * @since 1.0.0
     */
    public function elementor_style()
    {
        add_action('elementor/editor/before_enqueue_scripts', function () {

            echo '<style id="uicore-csss" >
            .elementor-element .icon .ui-e-widget:after {
              height: 28px;
              width: 28px;
              margin-right: 10px;
              border-radius: 3px;
              background-color: #532df5;
              background-image: url("data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' width=\'16\' height=\'16\' viewBox=\'0 0 16 16\' xml:space=\'preserve\'%3E%3Cpath d=\'M5.383 15.217c3.1 0 5.4-2.3 5.4-5.3v-7.9h-2.9v7.9c0 1.4-1.1 2.5-2.5 2.5s-2.5-1.1-2.5-2.5v-7.9h-2.9v7.9c0 3 2.3 5.3 5.4 5.3zM14.283 4.117c1 0 1.7-.7 1.7-1.7s-.7-1.7-1.7-1.7-1.7.7-1.7 1.7.7 1.7 1.7 1.7zM15.683 15.017v-9.6h-2.8v9.6z\' fill=\'%23fff\'/%3E%3C/svg%3E");
              background-size: 16px;
              background-position: center;
              background-repeat: no-repeat;
            }

            .elementor-element .icon .ui-e-widget:after {
				content: "";
			    position: absolute;
			    right: 5px;
			    top: 5px;
			    margin-right: 0;
			    width: 16px;
			    height: 16px;
			    background-size: 9px;
			    background-color: #656c7196;
				transition: background-color .3s ease-in-out;
            }
			.elementor-element:hover .icon .ui-e-widget:after {
				background-color: #532df5;
				transition: background-color .3s ease-in-out;
			}
            </style>';
        });
    }

    /**
     * Add initialization hooks
     *
     * @return void
     */
    public function init_hooks() {
        add_action( 'admin_enqueue_scripts', [ $this, 'enqueue_scripts' ] );
    }

    /**
     * Enqueue scripts and styles
     *
     * @return void
     */
    public function enqueue_scripts() {
        $data = 'var uianim = ' . wp_json_encode( [
            'disable' => get_option( 'uianim_disable', false ),
            'style' => get_option( 'uianim_style', '' ),
            'rest' => \get_rest_url( null, 'uianim/v1/settings'),
            'root' => \get_site_url(),
            'nonce' => wp_create_nonce( 'wp_rest' ),
            'connect' => get_option( 'uianim_connect', 'none' ),
        ] ) . ';';
        wp_enqueue_script( 'uicore_animate-settings');
        wp_enqueue_style( 'uicore_animate-settings');
        wp_add_inline_script('uicore_animate-settings', $data, 'before');
    }

    /**
     * Render animation wrapper for Elementor editor
     *
     * @return void
     */
    public function animate_elementor_wrapp() {
        wp_enqueue_script( 'uicore_animate-admin' );
        wp_enqueue_style( 'uicore_animate-admin' );
        echo '<div id="uianim-wrapp"><div id="uianim-app"></div></div>';
    }

    public function connect_page_callback()
    {
        if(isset($_GET['connect'])){


           update_option( 'uielements_connect', esc_attr( sanitize_text_field($_GET['connect']) ) );

            echo '
			<style>
				.ui-connected-wrapper {
					display: flex;
				    align-items: start;
				    justify-content: center;
				    height: 100vh;
					margin-top: 100px;
				}
				.ui-connected {
					display: flex;
					flex-direction: column;
					align-items: center;
					align-content: center;
					max-width: 420px;
					padding: 50px 80px;
					background: white;
					border-radius: 6px;
					border: 2px solid #D5DBE4;
					text-align: center;
				}
				.ui-connected h2 {
					font-size: 24px;
				}
			</style>
			<div class="ui-connected-wrapper">
				<div class="ui-connected">
					<h2>Your website is connected 🥳</h2>
					<p>Set off the fireworks! Your new website was successfully connected and ready to go.</p>
					<p><a href="'.esc_url( get_admin_url(null,'options-general.php?page=uicore-elements') ).'">Take me to Settings Page</a>.</p>
				</div>
			</div>';
        }

    }
}